
## **File Inspection and Hash-Based Recognition**

- **SHA-256 Hash Use:**
    
    - Computes the file’s SHA-256 hash and queries the Cisco Secure Endpoint cloud for file disposition.
    - If the verdict is unknown, the file is sent to the Cisco Secure Malware Analytics cloud for dynamic analysis.
    - Cisco Secure Malware Analytics sends conviction results to the cloud for global dissemination.
- **Advantages of SHA-256 Hash:**
    
    - Identifies malware masquerading as legitimate files and blocks threats without dynamic analysis.
    - Rapid sharing of threat intelligence across all AMP-enabled solutions.
- **Limitations:**
    
    - Hash-based recognition is insufficient for advanced threats (e.g., polymorphic malware) that generate new hashes for each variant.

---

## **Detection Engines Beyond SHA-256**

- **Multiple Threat-Centric Engines:**
    - Protect against both known and unknown threats.
    - Improve accuracy without slowing down business operations.

### **1. One-to-One Signatures**

- **Overview:**
    - Traditional antivirus approach.
    - Quickly captures known malicious files using unique file fingerprints (hashes).
- **Cisco Secure Endpoint Enhancements:**
    - Cloud-enabled coverage.
    - Full signature database protection.
    - Custom detection capabilities (admin-created block lists).
- **Benefits:**
    - Simple and fast detection of known threats.

### **2. Ethos Fuzzy Fingerprinting**

- **Features:**
    - Detects malware families by analyzing structural properties of code rather than binary contents.
    - Focuses on code snippets or artifacts recognized as malicious.
- **Capabilities:**
    - Identifies polymorphic variants of malware.
    - Detects original malware and its variants with static/passive heuristics.
- **Benefits:**
    - Addresses limitations of one-to-one signatures by detecting malware families.

### **3. Spero Machine Learning**

- **Features:**
    - Uses machine learning to recognize unknown artifacts and infer malicious behavior based on similar past threats.
    - Aims for zero-day malware detection.
- **Process:**
    - Automatically constructs a detection model using clean and malicious data.
    - Discovers patterns beyond human analyst capabilities.
- **Benefits:**
    - Identifies malicious software based on general appearance, not specific patterns or signatures.

### **4. TETRA Antivirus (Offline Capability)**

- **Purpose:**
    - Provides offline antivirus scanning for endpoints without cloud connectivity.
- **Details:**
    - Requires 1GB of disk space for antivirus definitions.
    - Recommended to disable if another antivirus is in use to avoid conflicts.
- **Mac/Linux Difference:**
    - Uses ClamAV instead of TETRA.

---

## **Exploit Prevention and Process Protection**

- **Exploit Prevention:**
    - Protects applications by spoofing memory addresses and using decoy memory to detect malicious access attempts.
- **System Process Protection:**
    - Protects critical processes like `smss.exe`, `lsass.exe`, and `winlogon.exe`.
- **Protected Applications:**
    - Microsoft Office Suite (Word, Excel, PowerPoint, etc.), Google Chrome, Mozilla Firefox, Adobe Acrobat Reader, Zoom, Cisco Webex, and more.

---

## **Indicators of Compromise (IOC)**

- **Definition:**
    - Artifacts or behavior patterns indicating a system has been compromised.
- **Key Features:**
    - Uses the OpenIOC framework to describe and identify IOCs.
    - Provides high-confidence insights into a host’s state (infected or clean).
- **Process:**
    - Manual creation and scanning process (can take hours to days).

---

## **Device Flow Correlation (DFC)**

- **Purpose:**
    - Tracks kernel-level network connections initiated by monitored files/processes.
- **Functions:**
    - Monitors internal and external networks.
    - Filters connections based on IP reputation data or custom-defined lists.
    - Logs URLs and domains.
    - Detects and removes dropper files from unknown threats.

---

## **Automatic Analysis (Sandboxing)**

- **Process:**
    - Runs suspicious files in a sandbox environment (Cisco Secure Malware Analytics).
    - Detects zero-day and unknown malware.
- **Limitations:**
    - Modern malware might evade sandboxing by being environmentally aware or using sleep timers.
- **Configuration:**
    - Automatic analysis is triggered only if enabled and the file verdict is unknown.

---

### **Key Takeaways**

- Cisco Secure Endpoint combines traditional and advanced detection techniques (e.g., SHA-256 hashes, Ethos, Spero, and TETRA).
- It protects against both known and unknown threats, including polymorphic malware.
- Advanced prevention mechanisms, such as exploit prevention and process protection, enhance endpoint security.
- Sandboxing and machine learning provide robust defenses against zero-day threats.